/*
 * MPIparalelization.h
 *
 *  Created on: Nov 19, 2013
 *      Author: nino
 */

#ifndef MPIPARALELIZATION_H_
#define MPIPARALELIZATION_H_

#include <StandardLibs.h>
#include <LikelihoodEstimators.h>
#include <ContagionStatistics.h>
#include <ContagionModels.h>
#include <NetworkStructure.h>
#include <Imports.h>
#include <Exports.h>
#include <IgraphVersionCompile.h>

#define MASTER_PROCESS_ID 0
#define COLLECTOR_PROCESS_ID 1
#define TAG_WORKER_MASTER 1
#define TAG_MASTER_WORKER 2
#define TAG_WORKER_COLLECTOR 3
#define TAG_DOUBLE_WORKER_COLLECTOR 4
#define REQ_SIZE 1
#define REQ_STOP -1
#define REQ_GIVE_DATA 1
#define PI 3.1415926535897

#define ANS_DATA_SIZE 3
#define ANS_SIZE 4
#define ANS_STOP_WORK -1
#define ANS_CONTINUE_WORK 1

#define SINGLE_SOURCE_CLASS 1
#define DOUBLE_SOURCE_CLASS 2
#define MULTIPLE_SOURCE_CLASS 2
#define USE_SEX_TEMPORAL_NETWORK 0
#define NUM_TEMPORAL_SNAPSHOTS 10
#define READ_TEMPORAL_DAY_REALIZATIONS 0
#define OUTPUT_LIKELIHOOD_PROBABILITIES 1
#define CALC_SHORTEST_PATHS_WORKERS 0

#define DEBUG 1
#define OVERWRITE_RESULTS 1
#define DEBUG_PRINT 0
#define SAMPLE_RANDOM_PAIRS 0

#define BENCHMARK_PHASE_1 1
#define BENCHMARK_PHASE_2 2
#define BENCHMARK_FILE_PATH "/home/nino/ssd/EPI_code/Results/Benchmark/"

int master_process_likelihood_singles(int mpi_size, int mpi_rank, int no_of_nodes_set, int * nodes_set, int source_node_id);

//int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, int T_value, double * scoreAll,  int realization_id );
//int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, double * scoreAll,  int realization_id );
//int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, statistics * statistic_parameters ,  int realization_id );

int collector_process_likelihood_singles(input* input_args, infected_structure * p_infected_parameters, int mpi_rank, statistics * statistic_parameters ,  int realization_id, likelihood_struct * likelihood_tmp );

int worker_process_likelihood_singles(int mpi_rank, input* input_args, infected_structure * p_infected_parameters, statistics * statistic_parameters, contagion_param_struct * epidemicParameters_exp, likelihood_struct * likelihood_tmp);

#endif /* MPIPARALELIZATION_H_ */
